<?php
/**
 * RefundEntity
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payment Gateway APIs
 *
 * Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2023-08-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * RefundEntity Class Doc Comment
 *
 * @category Class
 * @description The refund entity
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RefundEntity implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RefundEntity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'cf_payment_id' => 'string',
        'cf_refund_id' => 'string',
        'order_id' => 'string',
        'refund_id' => 'string',
        'entity' => 'string',
        'refund_amount' => 'float',
        'refund_currency' => 'string',
        'refund_note' => 'string',
        'refund_status' => 'string',
        'refund_arn' => 'string',
        'refund_charge' => 'float',
        'status_description' => 'string',
        'metadata' => 'object',
        'refund_splits' => '\Cashfree\Model\VendorSplit[]',
        'refund_type' => 'string',
        'refund_mode' => 'string',
        'created_at' => 'string',
        'processed_at' => 'string',
        'refund_speed' => '\Cashfree\Model\RefundSpeed'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'cf_payment_id' => null,
        'cf_refund_id' => null,
        'order_id' => null,
        'refund_id' => null,
        'entity' => null,
        'refund_amount' => null,
        'refund_currency' => null,
        'refund_note' => null,
        'refund_status' => null,
        'refund_arn' => null,
        'refund_charge' => null,
        'status_description' => null,
        'metadata' => null,
        'refund_splits' => null,
        'refund_type' => null,
        'refund_mode' => null,
        'created_at' => null,
        'processed_at' => null,
        'refund_speed' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'cf_payment_id' => false,
		'cf_refund_id' => false,
		'order_id' => false,
		'refund_id' => false,
		'entity' => false,
		'refund_amount' => false,
		'refund_currency' => false,
		'refund_note' => false,
		'refund_status' => false,
		'refund_arn' => false,
		'refund_charge' => false,
		'status_description' => false,
		'metadata' => false,
		'refund_splits' => false,
		'refund_type' => false,
		'refund_mode' => false,
		'created_at' => false,
		'processed_at' => false,
		'refund_speed' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'cf_payment_id' => 'cf_payment_id',
        'cf_refund_id' => 'cf_refund_id',
        'order_id' => 'order_id',
        'refund_id' => 'refund_id',
        'entity' => 'entity',
        'refund_amount' => 'refund_amount',
        'refund_currency' => 'refund_currency',
        'refund_note' => 'refund_note',
        'refund_status' => 'refund_status',
        'refund_arn' => 'refund_arn',
        'refund_charge' => 'refund_charge',
        'status_description' => 'status_description',
        'metadata' => 'metadata',
        'refund_splits' => 'refund_splits',
        'refund_type' => 'refund_type',
        'refund_mode' => 'refund_mode',
        'created_at' => 'created_at',
        'processed_at' => 'processed_at',
        'refund_speed' => 'refund_speed'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'cf_payment_id' => 'setCfPaymentId',
        'cf_refund_id' => 'setCfRefundId',
        'order_id' => 'setOrderId',
        'refund_id' => 'setRefundId',
        'entity' => 'setEntity',
        'refund_amount' => 'setRefundAmount',
        'refund_currency' => 'setRefundCurrency',
        'refund_note' => 'setRefundNote',
        'refund_status' => 'setRefundStatus',
        'refund_arn' => 'setRefundArn',
        'refund_charge' => 'setRefundCharge',
        'status_description' => 'setStatusDescription',
        'metadata' => 'setMetadata',
        'refund_splits' => 'setRefundSplits',
        'refund_type' => 'setRefundType',
        'refund_mode' => 'setRefundMode',
        'created_at' => 'setCreatedAt',
        'processed_at' => 'setProcessedAt',
        'refund_speed' => 'setRefundSpeed'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'cf_payment_id' => 'getCfPaymentId',
        'cf_refund_id' => 'getCfRefundId',
        'order_id' => 'getOrderId',
        'refund_id' => 'getRefundId',
        'entity' => 'getEntity',
        'refund_amount' => 'getRefundAmount',
        'refund_currency' => 'getRefundCurrency',
        'refund_note' => 'getRefundNote',
        'refund_status' => 'getRefundStatus',
        'refund_arn' => 'getRefundArn',
        'refund_charge' => 'getRefundCharge',
        'status_description' => 'getStatusDescription',
        'metadata' => 'getMetadata',
        'refund_splits' => 'getRefundSplits',
        'refund_type' => 'getRefundType',
        'refund_mode' => 'getRefundMode',
        'created_at' => 'getCreatedAt',
        'processed_at' => 'getProcessedAt',
        'refund_speed' => 'getRefundSpeed'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ENTITY_REFUND = 'refund';
    public const ENTITY_UNKNOWN_DEFAULT_OPEN_API = 'unknown_default_open_api';
    public const REFUND_STATUS_SUCCESS = 'SUCCESS';
    public const REFUND_STATUS_PENDING = 'PENDING';
    public const REFUND_STATUS_CANCELLED = 'CANCELLED';
    public const REFUND_STATUS_ONHOLD = 'ONHOLD';
    public const REFUND_STATUS_UNKNOWN_DEFAULT_OPEN_API = 'unknown_default_open_api';
    public const REFUND_TYPE_PAYMENT_AUTO_REFUND = 'PAYMENT_AUTO_REFUND';
    public const REFUND_TYPE_MERCHANT_INITIATED = 'MERCHANT_INITIATED';
    public const REFUND_TYPE_UNRECONCILED_AUTO_REFUND = 'UNRECONCILED_AUTO_REFUND';
    public const REFUND_TYPE_UNKNOWN_DEFAULT_OPEN_API = 'unknown_default_open_api';
    public const REFUND_MODE_STANDARD = 'STANDARD';
    public const REFUND_MODE_INSTANT = 'INSTANT';
    public const REFUND_MODE_UNKNOWN_DEFAULT_OPEN_API = 'unknown_default_open_api';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getEntityAllowableValues()
    {
        return [
            self::ENTITY_REFUND,
            self::ENTITY_UNKNOWN_DEFAULT_OPEN_API,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRefundStatusAllowableValues()
    {
        return [
            self::REFUND_STATUS_SUCCESS,
            self::REFUND_STATUS_PENDING,
            self::REFUND_STATUS_CANCELLED,
            self::REFUND_STATUS_ONHOLD,
            self::REFUND_STATUS_UNKNOWN_DEFAULT_OPEN_API,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRefundTypeAllowableValues()
    {
        return [
            self::REFUND_TYPE_PAYMENT_AUTO_REFUND,
            self::REFUND_TYPE_MERCHANT_INITIATED,
            self::REFUND_TYPE_UNRECONCILED_AUTO_REFUND,
            self::REFUND_TYPE_UNKNOWN_DEFAULT_OPEN_API,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRefundModeAllowableValues()
    {
        return [
            self::REFUND_MODE_STANDARD,
            self::REFUND_MODE_INSTANT,
            self::REFUND_MODE_UNKNOWN_DEFAULT_OPEN_API,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('cf_payment_id', $data ?? [], null);
        $this->setIfExists('cf_refund_id', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('refund_id', $data ?? [], null);
        $this->setIfExists('entity', $data ?? [], null);
        $this->setIfExists('refund_amount', $data ?? [], null);
        $this->setIfExists('refund_currency', $data ?? [], null);
        $this->setIfExists('refund_note', $data ?? [], null);
        $this->setIfExists('refund_status', $data ?? [], null);
        $this->setIfExists('refund_arn', $data ?? [], null);
        $this->setIfExists('refund_charge', $data ?? [], null);
        $this->setIfExists('status_description', $data ?? [], null);
        $this->setIfExists('metadata', $data ?? [], null);
        $this->setIfExists('refund_splits', $data ?? [], null);
        $this->setIfExists('refund_type', $data ?? [], null);
        $this->setIfExists('refund_mode', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('processed_at', $data ?? [], null);
        $this->setIfExists('refund_speed', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getEntityAllowableValues();
        if (!is_null($this->container['entity']) && !in_array($this->container['entity'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'entity', must be one of '%s'",
                $this->container['entity'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getRefundStatusAllowableValues();
        if (!is_null($this->container['refund_status']) && !in_array($this->container['refund_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'refund_status', must be one of '%s'",
                $this->container['refund_status'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getRefundTypeAllowableValues();
        if (!is_null($this->container['refund_type']) && !in_array($this->container['refund_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'refund_type', must be one of '%s'",
                $this->container['refund_type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getRefundModeAllowableValues();
        if (!is_null($this->container['refund_mode']) && !in_array($this->container['refund_mode'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'refund_mode', must be one of '%s'",
                $this->container['refund_mode'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets cf_payment_id
     *
     * @return string|null
     */
    public function getCfPaymentId()
    {
        return $this->container['cf_payment_id'];
    }

    /**
     * Sets cf_payment_id
     *
     * @param string|null $cf_payment_id Cashfree Payments ID of the payment for which refund is initiated
     *
     * @return self
     */
    public function setCfPaymentId($cf_payment_id)
    {
        if (is_null($cf_payment_id)) {
            throw new \InvalidArgumentException('non-nullable cf_payment_id cannot be null');
        }
        $this->container['cf_payment_id'] = $cf_payment_id;

        return $this;
    }

    /**
     * Gets cf_refund_id
     *
     * @return string|null
     */
    public function getCfRefundId()
    {
        return $this->container['cf_refund_id'];
    }

    /**
     * Sets cf_refund_id
     *
     * @param string|null $cf_refund_id Cashfree Payments ID for a refund
     *
     * @return self
     */
    public function setCfRefundId($cf_refund_id)
    {
        if (is_null($cf_refund_id)) {
            throw new \InvalidArgumentException('non-nullable cf_refund_id cannot be null');
        }
        $this->container['cf_refund_id'] = $cf_refund_id;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id Merchant’s order Id of the order for which refund is initiated
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets refund_id
     *
     * @return string|null
     */
    public function getRefundId()
    {
        return $this->container['refund_id'];
    }

    /**
     * Sets refund_id
     *
     * @param string|null $refund_id Merchant’s refund ID of the refund
     *
     * @return self
     */
    public function setRefundId($refund_id)
    {
        if (is_null($refund_id)) {
            throw new \InvalidArgumentException('non-nullable refund_id cannot be null');
        }
        $this->container['refund_id'] = $refund_id;

        return $this;
    }

    /**
     * Gets entity
     *
     * @return string|null
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity
     *
     * @param string|null $entity Type of object
     *
     * @return self
     */
    public function setEntity($entity)
    {
        if (is_null($entity)) {
            throw new \InvalidArgumentException('non-nullable entity cannot be null');
        }
        $allowedValues = $this->getEntityAllowableValues();
        if (!in_array($entity, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'entity', must be one of '%s'",
                    $entity,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets refund_amount
     *
     * @return float|null
     */
    public function getRefundAmount()
    {
        return $this->container['refund_amount'];
    }

    /**
     * Sets refund_amount
     *
     * @param float|null $refund_amount Amount that is refunded
     *
     * @return self
     */
    public function setRefundAmount($refund_amount)
    {
        if (is_null($refund_amount)) {
            throw new \InvalidArgumentException('non-nullable refund_amount cannot be null');
        }
        $this->container['refund_amount'] = $refund_amount;

        return $this;
    }

    /**
     * Gets refund_currency
     *
     * @return string|null
     */
    public function getRefundCurrency()
    {
        return $this->container['refund_currency'];
    }

    /**
     * Sets refund_currency
     *
     * @param string|null $refund_currency Currency of the refund amount
     *
     * @return self
     */
    public function setRefundCurrency($refund_currency)
    {
        if (is_null($refund_currency)) {
            throw new \InvalidArgumentException('non-nullable refund_currency cannot be null');
        }
        $this->container['refund_currency'] = $refund_currency;

        return $this;
    }

    /**
     * Gets refund_note
     *
     * @return string|null
     */
    public function getRefundNote()
    {
        return $this->container['refund_note'];
    }

    /**
     * Sets refund_note
     *
     * @param string|null $refund_note Note added by merchant for the refund
     *
     * @return self
     */
    public function setRefundNote($refund_note)
    {
        if (is_null($refund_note)) {
            throw new \InvalidArgumentException('non-nullable refund_note cannot be null');
        }
        $this->container['refund_note'] = $refund_note;

        return $this;
    }

    /**
     * Gets refund_status
     *
     * @return string|null
     */
    public function getRefundStatus()
    {
        return $this->container['refund_status'];
    }

    /**
     * Sets refund_status
     *
     * @param string|null $refund_status This can be one of [\"SUCCESS\", \"PENDING\", \"CANCELLED\", \"ONHOLD\", \"FAILED\"]
     *
     * @return self
     */
    public function setRefundStatus($refund_status)
    {
        if (is_null($refund_status)) {
            throw new \InvalidArgumentException('non-nullable refund_status cannot be null');
        }
        $allowedValues = $this->getRefundStatusAllowableValues();
        if (!in_array($refund_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'refund_status', must be one of '%s'",
                    $refund_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['refund_status'] = $refund_status;

        return $this;
    }

    /**
     * Gets refund_arn
     *
     * @return string|null
     */
    public function getRefundArn()
    {
        return $this->container['refund_arn'];
    }

    /**
     * Sets refund_arn
     *
     * @param string|null $refund_arn The bank reference number for refund
     *
     * @return self
     */
    public function setRefundArn($refund_arn)
    {
        if (is_null($refund_arn)) {
            throw new \InvalidArgumentException('non-nullable refund_arn cannot be null');
        }
        $this->container['refund_arn'] = $refund_arn;

        return $this;
    }

    /**
     * Gets refund_charge
     *
     * @return float|null
     */
    public function getRefundCharge()
    {
        return $this->container['refund_charge'];
    }

    /**
     * Sets refund_charge
     *
     * @param float|null $refund_charge Charges in INR for processing refund
     *
     * @return self
     */
    public function setRefundCharge($refund_charge)
    {
        if (is_null($refund_charge)) {
            throw new \InvalidArgumentException('non-nullable refund_charge cannot be null');
        }
        $this->container['refund_charge'] = $refund_charge;

        return $this;
    }

    /**
     * Gets status_description
     *
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->container['status_description'];
    }

    /**
     * Sets status_description
     *
     * @param string|null $status_description Description of refund status
     *
     * @return self
     */
    public function setStatusDescription($status_description)
    {
        if (is_null($status_description)) {
            throw new \InvalidArgumentException('non-nullable status_description cannot be null');
        }
        $this->container['status_description'] = $status_description;

        return $this;
    }

    /**
     * Gets metadata
     *
     * @return object|null
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     *
     * @param object|null $metadata Key-value pair that can be used to store additional information about the entity. Maximum 5 key-value pairs
     *
     * @return self
     */
    public function setMetadata($metadata)
    {
        if (is_null($metadata)) {
            throw new \InvalidArgumentException('non-nullable metadata cannot be null');
        }
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets refund_splits
     *
     * @return \Cashfree\Model\VendorSplit[]|null
     */
    public function getRefundSplits()
    {
        return $this->container['refund_splits'];
    }

    /**
     * Sets refund_splits
     *
     * @param \Cashfree\Model\VendorSplit[]|null $refund_splits refund_splits
     *
     * @return self
     */
    public function setRefundSplits($refund_splits)
    {
        if (is_null($refund_splits)) {
            throw new \InvalidArgumentException('non-nullable refund_splits cannot be null');
        }
        $this->container['refund_splits'] = $refund_splits;

        return $this;
    }

    /**
     * Gets refund_type
     *
     * @return string|null
     */
    public function getRefundType()
    {
        return $this->container['refund_type'];
    }

    /**
     * Sets refund_type
     *
     * @param string|null $refund_type This can be one of [\"PAYMENT_AUTO_REFUND\", \"MERCHANT_INITIATED\", \"UNRECONCILED_AUTO_REFUND\"]
     *
     * @return self
     */
    public function setRefundType($refund_type)
    {
        if (is_null($refund_type)) {
            throw new \InvalidArgumentException('non-nullable refund_type cannot be null');
        }
        $allowedValues = $this->getRefundTypeAllowableValues();
        if (!in_array($refund_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'refund_type', must be one of '%s'",
                    $refund_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['refund_type'] = $refund_type;

        return $this;
    }

    /**
     * Gets refund_mode
     *
     * @return string|null
     */
    public function getRefundMode()
    {
        return $this->container['refund_mode'];
    }

    /**
     * Sets refund_mode
     *
     * @param string|null $refund_mode Method or speed of processing refund
     *
     * @return self
     */
    public function setRefundMode($refund_mode)
    {
        if (is_null($refund_mode)) {
            throw new \InvalidArgumentException('non-nullable refund_mode cannot be null');
        }
        $allowedValues = $this->getRefundModeAllowableValues();
        if (!in_array($refund_mode, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'refund_mode', must be one of '%s'",
                    $refund_mode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['refund_mode'] = $refund_mode;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Time of refund creation
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets processed_at
     *
     * @return string|null
     */
    public function getProcessedAt()
    {
        return $this->container['processed_at'];
    }

    /**
     * Sets processed_at
     *
     * @param string|null $processed_at Time when refund was processed successfully
     *
     * @return self
     */
    public function setProcessedAt($processed_at)
    {
        if (is_null($processed_at)) {
            throw new \InvalidArgumentException('non-nullable processed_at cannot be null');
        }
        $this->container['processed_at'] = $processed_at;

        return $this;
    }

    /**
     * Gets refund_speed
     *
     * @return \Cashfree\Model\RefundSpeed|null
     */
    public function getRefundSpeed()
    {
        return $this->container['refund_speed'];
    }

    /**
     * Sets refund_speed
     *
     * @param \Cashfree\Model\RefundSpeed|null $refund_speed refund_speed
     *
     * @return self
     */
    public function setRefundSpeed($refund_speed)
    {
        if (is_null($refund_speed)) {
            throw new \InvalidArgumentException('non-nullable refund_speed cannot be null');
        }
        $this->container['refund_speed'] = $refund_speed;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


